<?php if (!defined('VB_ENTRY')) die('Access denied.');

/*======================================================*\
|| ############################################### ||
|| # ----------------vBSmart Team - vBulletin 4.0.1Version ------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| #      This file may not be redistributed in whole or significant part    . # ||
|| ############################################### ||
\*======================================================*/


/**
 * @package vBCms
 * @subpackage Search
 * @author Ed Brown, vBulletin Development Team
 * @version $Id: article.php 30443 2009-04-23 21:55:01Z ebrown $
 * @since $Date: 2009-04-23 14:55:01 -0700 (Thu, 23 Apr 2009) $
 * @copyright vBulletin Solutions Inc.
 */

require_once DIR . '/vb/search/indexcontroller.php';
/**
 * @package vBulletin
 * @subpackage Search
 * @author Edwin Brown, vBulletin Development Team
 * @version $Revision: 30443 $
 * @since $Date: 2009-04-23 14:55:01 -0700 (Thu, 23 Apr 2009) $
 * @copyright vBulletin Solutions Inc.
 */
/**
 * vBCms_Search_IndexController_Article
 *
 * @package
 * @author ebrown
 * @copyright Copyright (c) 2009
 * @version $Id: article.php 30443 2009-04-23 21:55:01Z ebrown $
 * @access public
 */
class vBCms_Search_IndexController_Article extends vB_Search_IndexController
{
	/**
	 * indexes a single record
	 *
	 * @param integer $id : the record id to be indexed
	 */
	public function index($id)
	{
		global $vbulletin;
		//we just pull a record from the database.

		if ($record = $this->getIndexRecord($id))
		{
			if (intval($record['nosearch']))
			{
				$this->delete($id);
			}
			else
			{
				$indexer = vB_Search_Core::get_instance()->get_core_indexer();
				$fields = $this->recordToIndexfields($record);
				$indexer->index($fields);
			}
		}
	}

	/**
	 * This will index a range of id's
	 *
	 * @param integer $start
	 * @param integer $finish
	 */
	public function index_id_range($start, $finish)
	{
		for ($id = $start; $id <= $finish; $id++)
		{
			$this->index($id);
		}
	}


	/**
	 * deletes a single record
	 *
	 * @param integer $id : the record id to be removed from the index
	 */
	public function delete($id)
	{
		vB_Search_Core::get_instance()->get_core_indexer()->delete(
			vB_Types::instance()->getContentTypeID($this->package, $this->class), $id);
	}

	/**
	 *  standard constructor, takes no parameters. We do need to set
	 *  the content type
	 */
	public function __construct()
	{
		$this->contenttypeid = vB_Types::instance()->getContentTypeID(
			array('package' =>$this->package, 'class' => $this->class));
	}
	/**
	 * This function is used to give the indexer a record to index
	 *
	 * @param integer $id : the contentid of the article
	 * @param integer $contenttypeid : the contenttypeid. We could look it up,
	 *   but this is only called from the indexcontroller which already has it.
	 * @return
	 */
	public function getIndexRecord($id)
	{
		return vB::$vbulletin->db->query_first("SELECT u.username, n.userid, a.contentid,
		a.pagetext, i.title, n.publishdate, i.creationdate, i.html_title, n.nosearch
		FROM " . TABLE_PREFIX . "cms_article a
		LEFT JOIN " . TABLE_PREFIX . "cms_node n on n.contentid = a.contentid
  		LEFT JOIN " . TABLE_PREFIX . "cms_nodeinfo i on i.nodeid = n.nodeid
  		LEFT JOIN " . TABLE_PREFIX . "user u on u.userid = n.userid
		WHERE a.contentid = $id AND n.contenttypeid = "
		. $this->contenttypeid);
	}

	/**
	 * Converts the visitormessage table row to the indexable fieldset
	 *
	 * @param associative array $visitormessage
	 * @return associative array $fields= the fields populated to match the
	 *   searchcored table in the database
	 */
	private function recordToIndexfields($record)
	{
		global $vbulletin;
			$fields['contenttypeid'] = $this->contenttypeid;
		$fields['primaryid'] = $record['contentid'];
		$fields['dateline'] = $record['publishdate'] ?
			$record['publishdate'] :
			($record['creationdate'] ? $record['creationdate']: TIMENOW) ;
		$fields['userid'] = $record['userid'];
		$fields['username'] = $record['username'];
		$fields['title'] = $record['title'] ;
		$fields['keywordtext'] = $record['html_title'] .
			'; ' . $record['title'] . '; ' . $record['pagetext'];
		return $fields;
	}

	protected $class = 'Article';
	protected $package = 'vBCms';
	protected $contenttypeid;
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 17:48, Tue Jan 12th 2010
|| # SVN: $Revision: 30443 $
|| ####################################################################
\*======================================================================*/